/*******************************************************************************
* Device      : AD18F08
* Author      : Sunwangzhi
* Version     : V0.0.1
* Date        : 2022.3.24
* Description : 配置Timer3的pwm2/3/4映射到桥上后的pwm中心对齐模式；Timer3中断只在pwm的高低电平的中心位置产生；
				可输出三组pwm，输出脚PA0、PA1、PA2、PB0、PB1、PB2
********************************************************************************/

#include "AD18F08.h"

/******************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG 口不能做普通IO用）
* _LVREN_ON         :  使能LVR
* _LVT24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
*
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
*
******************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L    & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L     & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    & _ADCSP_ON_4L                                                                                       );

void GPIO_Init(void);
void PWM_Init(void);
void Hbridge_Init(void);
//==============================================================================================
// ----Function: 主程序
// --Parameters: None
// -----Returns: None
//---------Note: 配置输出tmr3 pwm2/3/4映射到桥上的中心对齐模式
//==============================================================================================
void main (void)
{

	GPIO_Init();     //所有IO初始化
	PWM_Init();		 //tmr3 pwm初始化配置
	Hbridge_Init();  //tme3 pwm映射到桥上
	IPEN = 0;	   	//禁止中断优先级
	PEIE = 1;    	//外设GIEL
	GIE = 1;     	//全局GIEH

	T3CON = 0X84;  ////使能timer3 使能中心对齐模式


	while(1);

}

//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断
	if(TMR3IF  &&  TMR3IE)
	{
		TMR3IF = 0;		//timer3中断标志位清0
	    PB3 =~PB3;
	}


}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//进入中断后系统自动关闭中断

}

/*******************************************************************************
// ----Function: GPIO_Init
// --Parameters:
// -----Returns: None
//---------Note:所有IO初始化
*******************************************************************************/

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式

	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0

	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉

	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出

	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}

/*******************************************************************************
// ----Function: PWM_Init
// --Parameters:
// -----Returns: None
//---------Note: tmr3 pwm2/3/4的初始化配置
*******************************************************************************/
void PWM_Init(void)
{
	TMR3IF = 0;      //清中断标志
	TMR3IP = 1;		 //高优先级中断
	TMR3IE = 1;      //开TMR3中断

	PWM2CON0 = 0X07;  //使能pwm2~4功能
	PWM2CON1 = 0X00;  //正向输出

	PWM2H = 0X05;     //75%
	PWM2L = 0XDC;

	PWM3H = 0X05;     //75%
	PWM3L = 0XDC;

	PWM4H = 0X05;     //75%
	PWM4L = 0XDC;


	PR3H = 0X07;
	PR3L = 0XD0;
	TMR3H = 0X00;
	TMR3L = 0X00;
}
/*******************************************************************************
// ----Function: Hbridge_Init
// --Parameters:
// -----Returns: None
//---------Note: 桥的配置
*******************************************************************************/
void Hbridge_Init(void)
{
	PXC=0x80;      //使能tmr3的pwm映射到桥上
	PME=0x3f;	   //桥上的pwm映射到io
	PCS=0x00;		////PWM10->pb0  pwm11->pa0 pwm20->pa1 pwm21->pa2 pwm00->pb2 pwm01->pb1
}
